document.addEventListener("DOMContentLoaded", function(){
    var login_btn = document.getElementById("login_btn");
    var new_regi = document.getElementById("new_regi");
    var textarea = document.getElementById("search_content");
    var btn = document.getElementById("btn");
    var madoshobox = document.getElementById("madoshobox");
    var reload = document.getElementById("reload");
    var add = document.getElementById("add");

    var span_1 = document.getElementById('1');
    var span_2 = document.getElementById('2');
    var span_3 = document.getElementById('3');
    var span_4 = document.getElementById('4');
    var span_5 = document.getElementById('5');

    var span_content = ["", "", "", "", ""];
    var span_content_free_flag = ["", "", "", "", ""];
    var select_num = 99;

    var responseText = "";
    // パスワードを取得して入力欄にセット
    chrome.storage.local.get(['content_storage'], function(result) {
        responseText = result.content_storage || ''; // 値がない場合は空文字列をセット

        if(!(responseText == '')){
            document.getElementById("login").style.display ="none";
            document.getElementById("madosho").style.display ="block";

            console.log('保存確認');

            var favorite_content= responseText.split("##&##");
            for (let i=0; i< favorite_content.length; i++){ 
                var content = favorite_content[i].split("##$##");

                if(content.length > 4){
                    span_content[i] = content[4];
                    if(content.length > 5){span_content_free_flag[i] = content[6];}

                    if(i == 0){span_1.innerText = content[3].substring(0, 20);}
                    else if(i == 1){span_2.innerText = content[3].substring(0, 20);}
                    else if(i == 2){span_3.innerText = content[3].substring(0, 20);}
                    else if(i == 3){span_4.innerText = content[3].substring(0, 20);}
                    else if(i == 4){span_5.innerText = content[3].substring(0, 20);}
                }
            }
        }
    });

    span_1.addEventListener("click", function() {
        span_1.style.backgroundColor = 'aqua';
        span_2.style.backgroundColor = 'white';
        span_3.style.backgroundColor = 'white';
        span_4.style.backgroundColor = 'white';
        span_5.style.backgroundColor = 'white';

        select_num = 1;
    });

    span_2.addEventListener("click", function() {
        span_1.style.backgroundColor = 'white';
        span_2.style.backgroundColor = 'aqua';
        span_3.style.backgroundColor = 'white';
        span_4.style.backgroundColor = 'white';
        span_5.style.backgroundColor = 'white';

        select_num = 2;
    });

    span_3.addEventListener("click", function() {
        span_1.style.backgroundColor = 'white';
        span_2.style.backgroundColor = 'white';
        span_3.style.backgroundColor = 'aqua';
        span_4.style.backgroundColor = 'white';
        span_5.style.backgroundColor = 'white';

        select_num = 3;
    });

    span_4.addEventListener("click", function() {
        span_1.style.backgroundColor = 'white';
        span_2.style.backgroundColor = 'white';
        span_3.style.backgroundColor = 'white';
        span_4.style.backgroundColor = 'aqua';
        span_5.style.backgroundColor = 'white';

        select_num = 4;
    });

    span_5.addEventListener("click", function() {
        span_1.style.backgroundColor = 'white';
        span_2.style.backgroundColor = 'white';
        span_3.style.backgroundColor = 'white';
        span_4.style.backgroundColor = 'white';
        span_5.style.backgroundColor = 'aqua';

        select_num = 5;
    });

    add.addEventListener("click", function() {
        chrome.tabs.create({ url: 'https://grimoire-ai.com/ainomadosho_chorome_extension/extension_pronpt_list.php' });
    });
    
    new_regi.addEventListener("click", function() {
        // アイコンがクリックされたときの処理
        chrome.tabs.create({ url: 'https://grimoire-ai.com' });
    });

    reload.addEventListener("click", function() {
        chrome.storage.local.set({ content_storage: '' }, function() {
            console.log('ローカルストレージ初期化完了'); 
            document.getElementById("login").style.display ="block";
            document.getElementById("madosho").style.display ="none";
        });
    });
    
    document.getElementById("login_btn").addEventListener("click", function (event) {
       
        console.log('送信');
        event.preventDefault();
    
        const form = document.getElementById("pronpt_list_post");
    
        const userId = form.elements["userid"].value;
        const password = form.elements["password"].value;
        const t = form.elements["t"].value;
        const phpEndpoint = 'https://www.grimoire-ai.com/API/eojrEesfE124Ef/send_list.php';
    
        const sendData = {
            userid: userId,
            password: password,
            t: t,
        };
    
        const xhr = new XMLHttpRequest();
    
        xhr.open('POST', phpEndpoint, true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    
        xhr.onreadystatechange = function () {
            if (xhr.readyState === XMLHttpRequest.DONE) {
                if (xhr.status === 200) {
                    responseText = xhr.responseText;

                    chrome.storage.local.set({ content_storage: responseText }, function() {console.log('ローカルストレージ保存完了'); });

                    var favorite_content= responseText.split("##&##");

                    for (let i=0; i< favorite_content.length; i++){ 
                        var content = favorite_content[i].split("##$##");

                        if(content.length > 4){
                            span_content[i] = content[4];
                            if(content.length > 5){span_content_free_flag[i] = content[6];}

                            if(i == 0){span_1.innerText = content[3].substring(0, 20);}
                            else if(i == 1){span_2.innerText = content[3].substring(0, 20);}
                            else if(i == 2){span_3.innerText = content[3].substring(0, 20);}
                            else if(i == 3){span_4.innerText = content[3].substring(0, 20);}
                            else if(i == 4){span_5.innerText = content[3].substring(0, 20);}
                        }
                    }

                    console.log('通信成功');
                } else {
                    console.error('Error:', xhr.status);
                }
            }
        };
    
        const formData = new FormData(form);
        const urlEncodedData = new URLSearchParams(formData).toString();

        xhr.send(urlEncodedData);

        document.getElementById("login").style.display ="none";
        document.getElementById("madosho").style.display ="block";
    });

    madoshobox.addEventListener("click", function(){
        _display = document.getElementById("mahoselectbox");
        if(_display.style.display == "block"){ _display.style.display ="none";}
        else{ _display.style.display ="block"; }     
    });

    textarea.addEventListener('input', function () {
        // textareaに入力があったときの処理をここに記述
        textarea.style.height = "10px";
        textarea.style.height = (textarea.scrollHeight) + "px";
    });

    btn.addEventListener('click', function () {

        var search_content = document.getElementById("search_content").value;
        var pronpt_content = "";
        var free_flag = "";

        if(select_num == 1){pronpt_content = span_content[0]; free_flag = span_content_free_flag[0]}
        else if(select_num == 2){pronpt_content = span_content[1]; free_flag = span_content_free_flag[1]}
        else if(select_num == 3){pronpt_content = span_content[2]; free_flag = span_content_free_flag[2]}
        else if(select_num == 4){pronpt_content = span_content[3]; free_flag = span_content_free_flag[3]}
        else if(select_num == 5){pronpt_content = span_content[4]; free_flag = span_content_free_flag[4]}

        search_content = search_content.replace(/\n/g, "\r\n");
        search_content = search_content.replace(/<br>/g, "");
        pronpt_content = pronpt_content.replace(/\n/g, "\r\n");
        pronpt_content = pronpt_content.replace(/<br>/g, "");

        //pronpt_content = pronpt_content.replace(/<\?gri.*?\?>/g, '');
        pronpt_content = pronpt_content.replace(/<\?gri((.|\n|\r)*?)\?>/g, "");
        pronpt_content = pronpt_content.replace(/\/\*((.|\n|\r)*?)\*\//g, "");

        if(free_flag == "1"){
            var final_content = "";
            if(pronpt_content.includes("<|input|>")){ final_content = pronpt_content.replaceAll("<|input|>", search_content); }
            else{ final_content = search_content + "\r\n" + pronpt_content}
            navigator.clipboard.writeText(final_content)
            .then(function () {
                // alert("魔法の言葉をクリップボードにコピーしました。");
            })
            .catch(function (err) {
                console.error('Failed to copy text: ', err);
            })
            ;           
        }else{
            navigator.clipboard.writeText("[命令]\r\n" + search_content + "\r\n[条件]\r\n" + pronpt_content)
                .then(function () {
                    // alert("魔法の言葉をクリップボードにコピーしました。");
                })
                .catch(function (err) {
                    console.error('Failed to copy text: ', err);
                })
                ;           
        }  
    });
});